<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FakeTradeConfig;
use App\Models\User;
use Illuminate\Http\Request;

class FakeTradeController extends Controller
{
    public function config()
    {
        $pageTitle  = 'System Trade/Fake Trade Configuration';
        $fakeConfig = FakeTradeConfig::first();
        return view('admin.fake_trade.config', compact('pageTitle', 'fakeConfig'));
    }

    public function saveConfig(Request $request)
    {
        $request->validate([
            'fake_trade_username'           => 'required',
            'max_buy_order'                 => 'required|integer',
            'buy_min_decrease'              => 'required|integer|min:0|max:100',
            'buy_max_decrease'              => 'required|integer|gt:buy_min_decrease|max:99',
            'buy_order_amount_range'        => 'required|numeric|min:0|max:100',
            'buy_matching_chance'           => 'required|numeric|min:0|max:100',
            'buy_matching_price'            => 'required|numeric|min:0',
            'buy_matching_with_fake_trade'  => 'required|in:0,1',
            'buy_order_remain_minutes'      => 'required|integer|min:0',
            'max_sell_order'                => 'required|integer',
            'sell_min_increase'             => 'required|integer|min:0',
            'sell_max_increase'             => 'required|integer|gt:sell_min_increase',
            'sell_order_amount_range'       => 'required|numeric|min:0|max:100',
            'sell_matching_chance'          => 'required|numeric|min:0|max:100',
            'sell_matching_price'           => 'required|numeric|min:0',
            'sell_matching_with_fake_trade' => 'required|in:0,1',
            'sell_order_remain_minutes'     => 'required|integer|min:0',
        ]);

        $user = User::where('username', $request->fake_trade_username)->first();

        if (!$user) {
            $notify[] = ['error', 'User not found'];
            return back()->withNotify($notify);
        }

        createWallet($user->id);

        $fakeTradeConfig                                = FakeTradeConfig::first();
        $fakeTradeConfig->fake_trade_user_id            = $user->id;
        $fakeTradeConfig->fake_trade_username           = $request->fake_trade_username;
        $fakeTradeConfig->max_buy_order                 = $request->max_buy_order;
        $fakeTradeConfig->buy_min_decrease              = $request->buy_min_decrease;
        $fakeTradeConfig->buy_max_decrease              = $request->buy_max_decrease;
        $fakeTradeConfig->buy_order_amount_range        = $request->buy_order_amount_range;
        $fakeTradeConfig->buy_matching_chance           = $request->buy_matching_chance;
        $fakeTradeConfig->buy_matching_price            = $request->buy_matching_price;
        $fakeTradeConfig->buy_matching_with_fake_trade  = $request->buy_matching_with_fake_trade;
        $fakeTradeConfig->buy_order_remain_minutes      = $request->buy_order_remain_minutes;
        $fakeTradeConfig->max_sell_order                = $request->max_sell_order;
        $fakeTradeConfig->sell_min_increase             = $request->sell_min_increase;
        $fakeTradeConfig->sell_max_increase             = $request->sell_max_increase;
        $fakeTradeConfig->sell_order_amount_range       = $request->sell_order_amount_range;
        $fakeTradeConfig->sell_matching_chance          = $request->sell_matching_chance;
        $fakeTradeConfig->sell_matching_with_fake_trade = $request->sell_matching_with_fake_trade;
        $fakeTradeConfig->sell_matching_price           = $request->sell_matching_price;
        $fakeTradeConfig->sell_order_remain_minutes     = $request->sell_order_remain_minutes;
        $fakeTradeConfig->save();

        $notify[] = ['success', 'Fake trade configuration updated successfully'];
        return back()->withNotify($notify);
    }

}
