<?php

namespace App\Http\Controllers\Gateway\Metamask;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Gateway\PaymentController;
use App\Models\Deposit;
use App\Models\Gateway;
use Illuminate\Http\Request;

class ProcessController extends Controller
{
    public static function process($deposit)
    {
        $alias = $deposit->gateway->alias;

        $send['track']  = $deposit->trx;
        $send['view']   = 'user.payment.' . $alias;
        $send['method'] = 'post';
        $send['url']    = route('ipn.' . $alias);
        return json_encode($send);
    }

    public function ipn(Request $request)
    {
        if ($request->trx_hash) {
            $deposit = Deposit::where('trx_hash', $request->trx_hash)->exists();
            if ($deposit) {
                return false;
            }

            $deposit = Deposit::where('trx', $request->trx)->first();

            if (!$deposit) {
                return false;
            }

            $deposit->trx_hash    = $request->trx_hash;
            $deposit->from_wallet = $request->from_wallet;
            $deposit->save();

            return true;
        }

        $metamask = Gateway::where('alias', 'Metamask')->first();
        $deposits = Deposit::initiated()->where('method_code', $metamask->code)->where('created_at', '>=', now()->subHours(24))->orderBy('last_cron')->limit(10)->get();

        $network = 'mainnet';
        // $network = 'testnet';

        foreach ($deposits as $deposit) {
            $deposit->last_cron = time();
            $deposit->save();

            if ($deposit->method_currency == 'ETH') {
                $rpcUrl                = $network == 'testnet' ? "https://rpc.ankr.com/eth_goerli" : "https://cloudflare-eth.com";
                $requiredConfirmations = $network == 'testnet' ? 1 : 12; // Goerli: 1, ETH mainnet: 12
            } else if ($deposit->method_currency == 'MATIC') {
                $rpcUrl                = $network == 'testnet' ? "https://rpc-amoy.polygon.technology" : "https://polygon-rpc.com";
                $requiredConfirmations = $network == 'testnet' ? 1 : 64; // Amoy:1, Polygon mainnet: 64
            } else if ($deposit->method_currency == 'BNB') {
                $rpcUrl                = $network == 'testnet' ? "https://data-seed-prebsc-1-s1.binance.org:8545" : "https://bsc-dataseed.binance.org";
                $requiredConfirmations = $network == 'testnet' ? 1 : 15; // BSC testnet:1, mainnet: 15
            } else {
                return false;
            }

            $trxHash = $deposit->trx_hash;
            $ch      = curl_init($rpcUrl);

            $payload = [
                "jsonrpc" => "2.0",
                "method"  => "eth_getTransactionReceipt",
                "params"  => [$trxHash],
                "id"      => 1,
            ];

            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            $receipt = json_decode(curl_exec($ch), true);

            if (!isset($receipt['result']) || $receipt['result'] === null) {
                return false; // transaction not yet mined
            }

            $txBlock = hexdec($receipt['result']['blockNumber']);
            $status  = $receipt['result']['status']; // 0x1 = success, 0x0 = fail

            $payload = [
                "jsonrpc" => "2.0",
                "method"  => "eth_blockNumber",
                "params"  => [],
                "id"      => 2,
            ];
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            $latestBlock = json_decode(curl_exec($ch), true);

            $currentBlock = hexdec($latestBlock['result']);

            $confirmations = $currentBlock - $txBlock;

            $payload = [
                "jsonrpc" => "2.0",
                "method"  => "eth_getTransactionByHash",
                "params"  => [$trxHash],
                "id"      => 3,
            ];
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            $txInfo = json_decode(curl_exec($ch), true);

            curl_close($ch);

            $from   = $txInfo['result']['from'] ?? null;
            $to     = $txInfo['result']['to'] ?? null;
            $value  = $txInfo['result']['value'] ?? "0x0";
            $amount = hexdec($value) / 1e18;

            $isConfirmed = ($confirmations >= $requiredConfirmations && $status === "0x1") ? true : false;

            if (!$isConfirmed) {
                return false;
            }

            if ($amount < $deposit->final_amount) {
                return false;
            }

            $toWalletAddress = json_decode($deposit->gatewayCurrency()->gateway_parameter)->wallet_address;

            if (strtolower($to) != strtolower($toWalletAddress)) {
                return false;
            }

            if (strtolower($from) != strtolower($deposit->from_wallet)) {
                return false;
            }

            PaymentController::userDataUpdate($deposit);
            return true;
        }
    }

}
