<?php

namespace App\Lib;

use App\Constants\Status;
use App\Events\Order as EventsOrder;
use App\Models\Order;
use App\Models\Wallet;
use Exception;

class FakeTrade
{
    public $fakeTradeConfig;
    public $upperLimit;
    public $divisor;

    public function __construct($fakeTradeConfig)
    {
        $precision             = 8;
        $this->upperLimit      = pow(10, $precision + 2);
        $this->divisor         = pow(10, $precision);
        $this->fakeTradeConfig = $fakeTradeConfig;
    }

    public function placeOrder($orderRates, $coinPair, $orderSide)
    {
        $amountRange = $orderSide == Status::BUY_SIDE_ORDER ? $this->fakeTradeConfig->buy_order_amount_range : $this->fakeTradeConfig->sell_order_amount_range;
        $percentGrid = ($coinPair->maximum_buy_amount - $coinPair->minimum_buy_amount) / 100;

        $minAmount = $coinPair->minimum_buy_amount;
        $maxAmount = $coinPair->minimum_buy_amount + ($percentGrid * $amountRange);

        foreach ($orderRates as $orderRate) {
            $amount      = $minAmount + (mt_rand() / mt_getrandmax()) * ($maxAmount - $minAmount);
            $totalAmount = $amount * $orderRate;

            $charge = ($totalAmount / 100) * ($orderSide == Status::BUY_SIDE_ORDER ? $coinPair->percent_charge_for_buy : $coinPair->percent_charge_for_sell);

            $userId = $this->fakeTradeConfig->fake_trade_user_id;

            $order                     = new Order();
            $order->trx                = getTrx();
            $order->user_id            = $userId;
            $order->pair_id            = $coinPair->id;
            $order->order_side         = $orderSide;
            $order->order_type         = Status::ORDER_TYPE_MARKET;
            $order->rate               = $orderRate;
            $order->amount             = $amount;
            $order->price              = $coinPair->marketData->price;
            $order->total              = $totalAmount;
            $order->charge             = $charge;
            $order->coin_id            = $coinPair->coin_id;
            $order->market_currency_id = $coinPair->market->currency_id;
            $order->is_bot             = Status::YES;
            $order->save();

            try {
                event(new EventsOrder($order, $coinPair->symbol));
            } catch (Exception $ex) {

            }
        }
    }

    public function getRandomOrderRate($coinPair, $openOrderRates, $orderSide)
    {
        $fakeTradeConfig = $this->fakeTradeConfig;
        $precision       = 8;
        $scale           = 10 ** $precision;

        $fakeTradeOrdersRate = [];
        $openOrderRates      = $this->removeHighPriceOrder($coinPair->coin->rate, $openOrderRates, $orderSide);

        if ($orderSide == Status::BUY_SIDE_ORDER) {
            $buyOrderCount = mt_rand(0, $fakeTradeConfig->max_buy_order);
            for ($i = 0; $i < $buyOrderCount; $i++) {
                if (count($openOrderRates) && $fakeTradeConfig->buy_matching_chance > 0 && mt_rand(0, $this->upperLimit) / $this->divisor < $fakeTradeConfig->buy_matching_chance) {
                    $randomNumber = $openOrderRates[array_rand($openOrderRates)];
                } else {
                    do {
                        $randomPercent = mt_rand($fakeTradeConfig->buy_min_decrease * $scale, $fakeTradeConfig->buy_max_decrease * $scale) / $scale;
                        $randomNumber  = decreaseNumberByPercent($coinPair->coin->rate, $randomPercent);
                    } while (in_array($randomNumber, $openOrderRates));
                }
                $fakeTradeOrdersRate[] = $randomNumber;
            }
        } else {
            $sellOrderCount = mt_rand(0, $fakeTradeConfig->max_sell_order);

            for ($i = 0; $i < $sellOrderCount; $i++) {
                if (count($openOrderRates) && $fakeTradeConfig->sell_matching_chance > 0 && mt_rand(0, $this->upperLimit) / $this->divisor < $fakeTradeConfig->sell_matching_chance) {
                    $randomNumber = $openOrderRates[array_rand($openOrderRates)];
                } else {
                    do {
                        $randomPercent = mt_rand($fakeTradeConfig->sell_min_increase * $scale, $fakeTradeConfig->sell_max_increase * $scale) / $scale;
                        $randomNumber  = increaseNumberByPercent($coinPair->coin->rate, $randomPercent);
                    } while (in_array($randomNumber, $openOrderRates));
                }
                $fakeTradeOrdersRate[] = $randomNumber;
            }
        }

        return $fakeTradeOrdersRate;
    }

    private function removeHighPriceOrder($rate, $openOrderRates, $orderSide)
    {
        if ($orderSide == Status::BUY_SIDE_ORDER) {
            $openOrderRates = array_filter($openOrderRates, function ($value) use ($rate) {
                $afterIncrease = $rate + $this->fakeTradeConfig->buy_matching_price / 100 * $rate;
                return $afterIncrease >= $value ? true : false;
            });
        } else {
            $openOrderRates = array_filter($openOrderRates, function ($value) use ($rate) {
                $afterDecrease = $rate - $this->fakeTradeConfig->sell_matching_price / 100 * $rate;
                return $afterDecrease <= $value ? true : false;
            });
        }
        return $openOrderRates;
    }

}
