@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-12">
            <div class="alert alert-primary p-3">
                <p> <i class="las la-info-circle"></i> @lang('Be aware to configure this. Any misconfiguration may result in loss of funds.')</p>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="card">
                <form action="{{ route('admin.fake.trade.config.save') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <h6 class="p-2 fw-bold">@lang('User Config')</h6>
                        <ul class="list-group">
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Select User')</p>
                                    <p class="mb-0">
                                        <small>@lang('Select the user you want to use for system trading. Order will placed by this user. Enter username')</small>
                                        @if ($fakeConfig->fake_trade_username)
                                            <strong>@lang('Current User') :
                                                <a href="{{ route('admin.users.detail', $fakeConfig->fake_trade_user_id) }}">{{ '@' . $fakeConfig->fake_trade_username }}</a>
                                            </strong>
                                        @endif
                                    </p>
                                </div>
                                <div class="form-group">
                                    <input type="text" name="fake_trade_username" value="{{ $fakeConfig->fake_trade_username }}" class="form-control" required>
                                </div>
                            </li>
                        </ul>
                        <h6 class="p-2 fw-bold">@lang('Buy Order Config')</h6>
                        <ul class="list-group">
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Max buy order')</p>
                                    <p class="mb-0">
                                        <small>@lang('The maximum number of buy orders that can be placed each time. If set to 5, then 0 to 5 orders will be placed each time.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <input type="number" step="1" name="max_buy_order" value="{{ $fakeConfig->max_buy_order }}" class="form-control" required>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Min Decrease')</p>
                                    <p class="mb-0">
                                        <small>@lang('The price decrease used to calculate the order rate. For example, if the current BTC rate is $70,000 and the minimum decrease is 10%, the order price will be less than $63,000.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" name="buy_min_decrease" step="1" value="{{ $fakeConfig->buy_min_decrease }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Max Decrease')</p>
                                    <p class="mb-0">
                                        <small>@lang('The maximum price decrease used to calculate the order rate. For example, if the current BTC rate is $70,000 and the maximum decrease is 20%, the order price will be greater than $56,000.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" name="buy_max_decrease" step="1" value="{{ $fakeConfig->buy_max_decrease }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>

                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Order Amount Range')</p>
                                    <p class="mb-0">
                                        <small>@lang('This configures the range for the order amount. For example, if it is set to 10% and the minimum buy amount in the CoinPair is 100 and max 300, then the order amount will be between 100 and 120.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="text" name="buy_order_amount_range" value="{{ getAmount($fakeConfig->buy_order_amount_range) }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Order Matching Chance')</p>
                                    <p class="mb-0">
                                        <small>@lang('This defines the probability of system trade orders matching with sell orders. For example, if it is set to 50% and the max buy order value is 10, then 0 to 5 orders will match with sell orders.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" name="buy_matching_chance" step="any" value="{{ getAmount($fakeConfig->buy_matching_chance) }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Order Matching Price Increase Up To')</p>
                                    <p class="mb-0">
                                        <small>@lang('This determines the range within which orders will be matched. For example, if this value is set to 10% and the current BTC price is $70,000, then orders with rates less then or equal to $77,000 will be matched.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" name="buy_matching_price" step="any" value="{{ getAmount($fakeConfig->buy_matching_price) }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Matching with System Trade')</p>
                                    <p class="mb-0">
                                        <small>@lang('This determines whether the order will match with a system trade or not. If set to "yes", the system trade will match with another system trade order. If set to "no", the system trade order will only match with real user orders.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <select name="buy_matching_with_fake_trade" class="form-control select2" data-minimum-results-for-search="-1" required>
                                        <option value="1">@lang('Yes')</option>
                                        <option value="0" @selected(!$fakeConfig->buy_matching_with_fake_trade)>@lang('No')</option>
                                    </select>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Order Remains')</p>
                                    <p class="mb-0">
                                        <small>@lang('This defines how many minutes the system trade order will stay in the system. After this period, the system trade order will be deleted/canceled.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" step="1" min="0" name="buy_order_remain_minutes" value="{{ $fakeConfig->buy_order_remain_minutes }}" class="form-control" required>
                                        <span class="input-group-text">@lang('Min')</span>
                                    </div>
                                </div>
                            </li>


                        </ul>

                        <h6 class="p-2 mt-3 fw-bold">@lang('Sell Order Config')</h6>
                        <ul class="list-group">
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Max Sell Order')</p>
                                    <p class="mb-0">
                                        <small>@lang('The maximum number of sell orders that can be placed each time. If set to 5, then 0 to 5 orders will be placed each time.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <input type="number" step="1" name="max_sell_order" value="{{ $fakeConfig->max_sell_order }}" class="form-control" required>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Min Increase')</p>
                                    <p class="mb-0">
                                        <small>@lang('The price increase used to calculate the order rate. For example, if the current BTC rate is $70,000 and the minimum increase is 10%, the order price will be greater than $77,000.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" name="sell_min_increase" step="1" value="{{ $fakeConfig->sell_min_increase }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Max Increase')</p>
                                    <p class="mb-0">
                                        <small>@lang('The maximum price increase used to calculate the order rate. For example, if the current BTC rate is $70,000 and the maximum increase is 20%, the order price will be less than $84,000.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" name="sell_max_increase" step="1" value="{{ $fakeConfig->sell_max_increase }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Order Amount Range')</p>
                                    <p class="mb-0">
                                        <small>@lang('This configures the range for the order amount. For example, if it is set to 10% and the minimum buy amount in the CoinPair is 100 and max 300, then the order amount will be between 100 and 120.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="text" name="sell_order_amount_range" value="{{ getAmount($fakeConfig->sell_order_amount_range) }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Order Matching Chance')</p>
                                    <p class="mb-0">
                                        <small>@lang('This defines the probability of system trade orders matching with buy orders. For example, if it is set to 50% and the max sell order value is 10, then 0 to 5 orders will match with buy orders.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" name="sell_matching_chance" step="any" value="{{ getAmount($fakeConfig->sell_matching_chance) }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Order Matching Price Decrease Up To')</p>
                                    <p class="mb-0">
                                        <small>@lang('This determines the range within which orders will be matched. For example, if this value is set to 10% and the current BTC price is $70,000, then orders with rates above or equal to $63,000 will be matched.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" name="sell_matching_price" step="any" value="{{ getAmount($fakeConfig->sell_matching_price) }}" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Matching with System Trade')</p>
                                    <p class="mb-0">
                                        <small>@lang('This determines whether the order will match with a system trade or not. If set to "yes", the system trade will match with another system trade order. If set to "no", the system trade order will only match with real user orders.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <select name="sell_matching_with_fake_trade" class="form-control select2" data-minimum-results-for-search="-1" required>
                                        <option value="1">@lang('Yes')</option>
                                        <option value="0" @selected(!$fakeConfig->sell_matching_with_fake_trade)>@lang('No')</option>
                                    </select>
                                </div>
                            </li>
                            <li class="list-group-item d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center">
                                <div>
                                    <p class="fw-bold mb-0">@lang('Order Remains')</p>
                                    <p class="mb-0">
                                        <small>@lang('This defines how many minutes the system trade order will stay in the system. After this period, the system trade order will be deleted.')</small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="number" step="1" min="0" name="sell_order_remain_minutes" value="{{ $fakeConfig->sell_order_remain_minutes }}" class="form-control" required>
                                        <span class="input-group-text">@lang('Min')</span>
                                    </div>
                                </div>
                            </li>

                        </ul>

                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .form-group {
            width: 160px;
            margin-bottom: 0;
            flex-shrink: 0
        }

        .form-control {
            background-color: white !important;
        }

        .list-group-item:hover {
            background-color: #F7F7F7
        }
    </style>
@endpush
